/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.locomotion.entity;

import cofh.lib.energy.EnergyStorageCoFH;
import cofh.lib.entity.AbstractMinecartCoFH;
import cofh.thermal.lib.util.ThermalEnergyHelper;
import cofh.thermal.locomotion.init.TLocReferences;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class EnergyMinecart
extends AbstractMinecartCoFH {
    public static final int BASE_CAPACITY = 8000000;
    public static final int BASE_XFER = 8000;
    protected EnergyStorageCoFH energyStorage = new EnergyStorageCoFH(8000000, 8000);
    protected LazyOptional<?> energyCap = LazyOptional.empty();

    public EnergyMinecart(EntityType<? extends EnergyMinecart> type, Level worldIn) {
        super(type, worldIn);
    }

    public EnergyMinecart(Level worldIn, double posX, double posY, double posZ) {
        super(TLocReferences.ENERGY_CART_ENTITY, worldIn, posX, posY, posZ);
    }

    public EnergyMinecart onPlaced(ItemStack stack) {
        super.onPlaced(stack);
        Map enchantMap = EnchantmentHelper.m_44882_((ListTag)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.energyStorage.applyModifiers(holdingMod, 1.0f);
        if (stack.m_41783_() != null) {
            this.energyStorage.read(stack.m_41783_());
        }
        return this;
    }

    public ItemStack createItemStackTag(ItemStack stack) {
        this.energyStorage.writeWithParams(stack.m_41784_());
        return super.createItemStackTag(stack);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Map enchantMap = EnchantmentHelper.m_44882_((ListTag)this.enchantments);
        float holdingMod = this.getHoldingMod(enchantMap);
        this.energyStorage.applyModifiers(holdingMod, 1.0f);
        this.energyStorage.read(compound);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.energyStorage.write(compound);
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)TLocReferences.ENERGY_CART_ITEM);
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ThermalEnergyHelper.getBaseEnergySystem()) {
            if (!this.energyCap.isPresent() && this.energyStorage.getCapacity() > 0) {
                this.energyCap = LazyOptional.of(() -> this.energyStorage);
            }
            return this.energyCap.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.energyCap.invalidate();
    }
}

